#!/bin/sh
# createemgdb-mysql.sh
#
# Sample script for creating an EMG database
# in a MySQL database server.
#
# Please verify carefully that the username,
# password and database information below is
# correct for your installation.
#
# SCRIPT PROVIDED AS IS.
# TO BE USED AT OWN RISK.

admuser=root
emgdb=emg
emguser=emguser
emgpasswd=secret
port=3306

while [ $# -gt 1 ]; do
	isok=0
#	echo arg: $1
	[ x$1 = x--pw ] && {
		[ $# -gt 0 ] || {
			echo "Missing arg to --pw."
			exit 1
		}
		shift
		emgpasswd="$1"
		isok=1
	}
	[ $isok = 0 ] && {
		echo Invalid argument: $1
		exit 1
	}
	shift
done

cmd=$1

[ "$emgpasswd" = "secret" ] && {
	echo
	echo "ERROR!!!"
	echo "Have you checked parameters in script?"
	echo "You need to edit this script and at least change the db password in variable \"emgpasswd\" on line 17."
	echo "We recommend generating a strong password using http://strongpasswordgenerator.com/"
	echo "Do not forget to write it down and store it in a safe place."
	echo
	exit 1
}

[ "$cmd" = "" ] && {
	echo "Please supply an operation:"
	echo "createdb"
	echo "dropdb"
	echo "createtables"
	echo "initdbconfig"
	echo "droptables"
	exit 1
}

mysqladmincmd="mysql -P$port -u$admuser -p -h127.0.0.1 mysql"
mysqlusercmd="mysql -P$port -u$emguser -p$emgpasswd -h127.0.0.1 $emgdb"

case $cmd in
createdb)
	echo "Create database... "
	echo "MySQL will prompt for MySQL root password:"

	# Create database and user
	$mysqladmincmd <<EOF
$dropdbsql
CREATE DATABASE $emgdb CHARACTER SET utf8;
CREATE USER $emguser@127.0.0.1 IDENTIFIED BY '$emgpasswd';
CREATE USER $emguser@"%" IDENTIFIED BY '$emgpasswd';
GRANT ALL PRIVILEGES ON $emgdb.* TO $emguser@127.0.0.1, $emguser@"%";
FLUSH PRIVILEGES
EOF
	;;

dropdb)
	echo "Drop database..."
$mysqlusercmd <<EOF
DROP DATABASE IF EXISTS $emgdb;
EOF
	;;

createtables)
	echo "Create tables..."
$mysqlusercmd < emg-schema-mysql.sql
	;;

initdbconfig)
	echo "Adding data to tables..."
$mysqlusercmd < initdbconfig.sql
	;;

droptables)
	echo "Drop tables..."
$mysqlusercmd <<EOF
DROP TABLE IF EXISTS pbentry;
DROP TABLE IF EXISTS pb;
DROP TABLE IF EXISTS messagebody;
DROP TABLE IF EXISTS messageoption;
DROP TABLE IF EXISTS connectorlog;
DROP TABLE IF EXISTS routelog;
DROP TABLE IF EXISTS pdulog;
DROP TABLE IF EXISTS monthlysummary;
DROP TABLE IF EXISTS emguseraccess;
DROP TABLE IF EXISTS emguser;
DROP TABLE IF EXISTS emgsystem;
DROP TABLE IF EXISTS cfg_connectoroptions;
DROP TABLE IF EXISTS cfg_connectors;
DROP TABLE IF EXISTS cfg_satpools;
DROP TABLE IF EXISTS cfg_plugins;
DROP TABLE IF EXISTS cfg_general;
EOF
	;;
esac

[ "$?" != "0" ] && {
	echo "failed!"
	exit 1
}

echo "OK"

exit 0

