#!/bin/sh

PATH=$PATH:/sbin:/usr/sbin

rl=2
if which runlevel; then
	rl="$(runlevel 2>/dev/null | awk '{print $2}')"
fi

if [ -z "$rl" ]; then
	echo "Failed to get runlevel info. Not starting emg_watchdog."
	exit 0
fi
if [ $rl -lt 2 -o $rl -gt 5 ]; then
	exit 0
fi

if [ -f $HOME/.bash_profile ]; then
	. $HOME/.bash_profile
fi

if [ -f $HOME/.zshenv ]; then
	. $HOME/.zshenv
fi

if [ -f $EMGDIR/block_watchdog ]; then
	continue
fi

# Enable core dumps.
ulimit -c unlimited

perl $HOME/bin/emg_watchdog.pl

exit 0

