#!/bin/bash
script=$1
filename=`basename $script .sh`
dir=$(cd `dirname $0` && pwd)
lockname=$dir/$filename.lock
(
  cd $dir
  flock -xn 200
  RETVAL=$?
  if [ $RETVAL -eq 1 ]; then
    exit 1
  else
    trap 'rm $lockname' 0
    while true; do
      sleep 5
      $script
    done
  fi
) 200>$lockname
exit 0
